<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Shelter extends Model 
{

    protected $table = 'shelters';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function zone()
    {
        return $this->belongsTo('Zone');
    }

    public function components()
    {
        return $this->hasMany('Component');
    }

}